#!/bin/bash
#! /bin/bash

model_name=GCLSTM
dataset=reddit_hyperlinks #auton-sys #opsahl-ucsocial #radoslaw #auton-sys
task=link_prediction #link_prediction
# saved_model=models/DySAT_pytorch/model_checkpoints/model
# if [ "$model_name" == DySAT_pytorch ]; then
#     saved_model=models/${model_name}/model_checkpoints/${dataset}/${task}
# else
#     saved_model=models/${model_name}/${dataset}/${task}
# fi
saved_model=models/${model_name}/${dataset}

num_graphs=20 #13 #14
context=19 #12 #13
target_ts=19 #12 #13
ntargets=1
nsamples=50 #100

method=pgd
constraint=noise

num_steps=50
lambda1=0
khop=2
nprocs=1

epsilon=0.1
budget=10

lr_init=10

online=false

if $online; then
    file=main_online.py
elif [ "$constraint" == noise_feat ]; then
    file=main_feat.py
elif [ "$nprocs" == 1 ]; then
    file=main.py
else
    file=main_parallel.py
fi

# declare -a budgets_arr=(10 20 30)
declare -a budgets_arr=(40 50 60)
# declare -a budgets_arr=(70 80 90)
# declare -a budgets_arr=(100 200 300)
# declare -a budgets_arr=(400 500)
#  40 50 60 70 80 90 100 200 300 400 500)
# declare -a budgetps_arr=(0.1 0.2 0.3)
# declare -a budgetps_arr=(0.4 0.5)
# declare -a budgetps_arr=(0.6 0.7)
# declare -a budgetps_arr=(0.8 0.9 1.0)


# declare -a epsilons_arr=(0.01 0.03)
# declare -a epsilons_arr=(0.05 0.07)
# declare -a epsilons_arr=(0.09 0.12)
# declare -a epsilons_arr=(0.14 0.16)
# declare -a epsilons_arr=(0.18 0.20)
# declare -a epsilons_arr=(0.3 0.4 0.5)
# declare -a epsilons_arr=(0.3)

# declare -a epsilons_arr=(0.1 0.2 0.3)
# declare -a epsilons_arr=(0.4 0.5 0.6)
# declare -a epsilons_arr=(0.7 0.8 0.9)

# declare -a epsilons_arr=(0.01 0.02) # cu1
# declare -a epsilons_arr=(0.03 0.04) # cu2
# declare -a epsilons_arr=(0.05 0.06) # cu3
# declare -a epsilons_arr=(0.08) # 0.09) # cu4

# declare -a epsilons_arr=(0.1 0.2) # cu3
# declare -a epsilons_arr=(0.3 0.4) # cu4
# declare -a epsilons_arr=(0.5 0.6) # cu5
# declare -a epsilons_arr=(0.7 0.8 0.9) # cu6

# declare -a epsilons_arr=(0.1 0.2 0.3)
# declare -a epsilons_arr=(0.4 0.5)
# declare -a epsilons_arr=(0.5 0.6)
# declare -a epsilons_arr=(0.7 0.8 0.9)
# declare -a epsilons_arr=(0.9)

# declare -a epsilons_arr=(0.08) #1
# declare -a epsilons_arr=(0.1) # 0.2) # 3
# declare -a epsilons_arr=(0.3 0.4) #4
# declare -a epsilons_arr=(0.5 0.6) #5
# declare -a epsilons_arr=(0.7) #6
# declare -a epsilons_arr=(0.8 0.9)


# declare -a epsilons_arr=(0.01 0.03) #
# declare -a epsilons_arr=(0.05 0.07 0.09) #3
# declare -a epsilons_arr=(0.6 0.7) # 4 
# declare -a epsilons_arr=(0.8 0.9) #6
# declare -a epsilons_arr=(0.02 0.04) #2
# declare -a epsilons_arr=(0.06 0.08) #2
# declare -a epsilons_arr=(0.1 0.2) # 5
# declare -a epsilons_arr=(0.3 0.4) # 5
# declare -a epsilons_arr=(0.5 0.6) # 5
# declare -a epsilons_arr=(0.7 0.8 0.9) #6
# declare -a epsilons_arr=(0.1 0.2 0.3 0.4) # 5

# declare -a epsilons_arr=(0.02 0.04 0.06 0.08) #2
# declare -a epsilons_arr=(0.06 0.08 0.1 0.2) # 5
# declare -a epsilons_arr=(0.3 0.4 0.5 0.6) # 5
# declare -a epsilons_arr=(0.1 0.2 0.3 0.4) # 5
# declare -a epsilons_arr=(0.5 0.6 0.7 0.8 0.9) # 5
# declare -a epsilons_arr=(0.02 0.06 0.1 0.3) # 5


# declare -a epsilons_arr=(0.02 0.06) #2
# declare -a epsilons_arr=(0.1 0.3) #2
# declare -a epsilons_arr=(0.5 0.7 0.9) # 5

# declare -a epsilons_arr=(0.02 0.06 0.1 0.3) #2
# declare -a epsilons_arr=(0.5 0.7 0.9) # 5

# declare -a epsilons_arr=(0.02 0.06 0.1 0.3 0.5 0.7 0.9) # 5

declare -a epsilons_arr=(0.5)

# epsilon1=$((ntargets * 2))
epsilon1=100

# 2 3 5 7 4, 6
resparent_dir="results_${model_name,,}"

if [ ! -d "${resparent_dir}/${dataset}/multi_targets/${method}/${constraint}" ]; then
    mkdir -p ${resparent_dir}/${dataset}/multi_targets/${method}/${constraint}
fi

seed=123 #123 483, 665, 811

echo $file
# for budget in "${budgets_arr[@]}"
for epsilon in "${epsilons_arr[@]}"
do
    python3 $file \
        -constraint ${constraint} \
        -budget ${budget} \
        -epsilon ${epsilon} \
        -epsilon1 ${epsilon1} \
        -model_name ${model_name} \
        -saved_model ${saved_model} \
        -dataset ${dataset} \
        -task ${task} \
        -num_graphs ${num_graphs} \
        -ntargets ${ntargets} \
        -khop ${khop} \
        -num_steps ${num_steps} \
        -lambda1 ${lambda1} \
        -context ${context} \
        -target_ts ${target_ts} \
        -method ${method} \
        -featureless \
        -num_samples $nsamples \
        -device cuda:5 \
        -pll_devices cuda:0 cuda:2 cuda:3 cuda:5  \
        -neg_sampling \
        -seed ${seed} \
        -lr_init ${lr_init} \
        -nprocs $nprocs \
        -use_optim \
        -sampling None \
        -inits ones 
        # -dyn_feats \
        # > ${resparent_dir}/${dataset}/multi_targets/${method}/${constraint}/results_td_tg${ntargets}_n${num_graphs}_c${context}t${target_ts}_e${epsilon}_eb${epsilon1}_l${lambda1}_seed${seed}.txt
        # b${budget}_l${lambda1}.txt 
        # -seq_tg_attk \
        # -seq_order deg_desc \
        #  
        # -large_graph \
done

# cu:1, 2, 3, 4, 5, 6, 7
